/*
 * Decompiled with CFR 0.152.
 */
package sufftracker;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import sufftracker.Contestant;
import sufftracker.SaveObject;
import sufftracker.SettingsHolder;
import sufftracker.WebSync;

public class DataHolder
extends Observable
implements Observer {
    private ArrayList<Contestant> contestants = new ArrayList();
    private File file = new File("suff.txt");
    private String splitter = "#~!";
    private int maximum = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadData() {
        try {
            if (!this.file.createNewFile()) {
                // empty if block
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.file));
            ArrayList<String> names = new ArrayList<String>();
            long ts = WebSync.instance().latestTimestamp();
            while ((line = br.readLine()) != null) {
                String[] d = line.split(this.splitter);
                if (d.length != 3) continue;
                int a = Integer.valueOf(d[1]);
                if (a > this.maximum) {
                    this.maximum = a;
                }
                long ts_d = Long.valueOf(d[2]);
                SaveObject s = new SaveObject(d[0], a, ts_d);
                if (ts_d > ts) {
                    WebSync.instance().push(line + this.splitter);
                }
                if (!names.contains(d[0])) {
                    names.add(d[0]);
                    Contestant c = new Contestant(s);
                    c.addObserver(this);
                    this.contestants.add(c);
                    continue;
                }
                this.contestant(s.person).push(s);
            }
        }
        catch (IOException ex) {
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {}
        }
        Collections.sort(this.contestants);
    }

    public void ereaseSession() {
        this.file.renameTo(new File("suff_old_" + SettingsHolder.instance().getString("session") + "_" + System.currentTimeMillis() + ".txt"));
        SettingsHolder.instance().ereaseSession();
    }

    public Contestant contestant(String name) {
        for (Contestant c : this.contestants) {
            if (!c.latest.person.equals(name)) continue;
            return c;
        }
        return null;
    }

    public int getNumPlayers() {
        return this.contestants.size();
    }

    public int getMax() {
        return this.maximum;
    }

    public int getNumConsumed() {
        int drink = 0;
        for (Contestant c : this.contestants) {
            drink += c.latest.amount;
        }
        return drink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(String name, int amount) {
        if (this.maximum < amount) {
            this.maximum = amount;
        }
        BufferedWriter bw = null;
        SaveObject s = null;
        try {
            s = new SaveObject(name, amount, System.currentTimeMillis());
            Contestant c = this.contestant(name);
            if (c == null) {
                c = new Contestant(s);
                c.addObserver(this);
                this.contestants.add(c);
            }
            bw = new BufferedWriter(new FileWriter(this.file, true));
            String line = s.person + this.splitter + s.amount + this.splitter + s.timestamp;
            bw.write(line + "\n");
            bw.close();
            WebSync.instance().push(line + this.splitter);
        }
        catch (IOException ex) {
            Logger.getLogger(DataHolder.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(DataHolder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Collections.sort(this.contestants);
    }

    public void addContestant(Component where) {
        String def = "Spielername";
        String name = JOptionPane.showInputDialog(where, "Gebe einen Namen ein", def);
        if (name == null) {
            return;
        }
        if ((name = name.trim()).isEmpty() || name.equals(def)) {
            JOptionPane.showMessageDialog(where, "Bitte gebe einen Namen ein.", "Leer", 0);
            return;
        }
        if (this.contestant(name) != null) {
            JOptionPane.showMessageDialog(where, "Bitte gebe einen andere Namen an - es existiert schon einer mit diesem Namen.", "Doppelt", 0);
            return;
        }
        this.push(name, 0);
        this.setChanged();
        this.notifyObservers("added" + name);
    }

    ArrayList<Contestant> getAllContestants() {
        return this.contestants;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof Contestant) {
            this.push(((Contestant)o).latest.person, ((Contestant)o).latest.amount);
            Collections.sort(this.contestants);
            this.setChanged();
            this.notifyObservers();
        }
    }
}

